/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.operaciones;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.validacion.ValidacionATS;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class OperacionValidacionAnexoAntiguo
implements IRunnableWithProgress {
    private File archivoXML;
    private String rutaXSD;
    private ResultadoValidacion resultadoValidacionEsquema = null;

    public OperacionValidacionAnexoAntiguo(File archivoXML, String rutaXSD) {
        this.archivoXML = archivoXML;
        this.rutaXSD = rutaXSD;
    }

    public ResultadoValidacion getResultadoValidacionEsquema() {
        return this.resultadoValidacionEsquema;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Preparando la validaci\u00f3n de esquema", -1);
        Thread.sleep(1000L);
        monitor.setTaskName("Aplicando validaci\u00f3n de esquema anexos versiones anteriores");
        Thread.sleep(500L);
        ResultadoValidacion resultado = null;
        ValidacionATS validacionATS = new ValidacionATS(this.archivoXML, this.rutaXSD);
        try {
            resultado = validacionATS.validarEsquemaAnexoAntiguo();
        }
        catch (FileNotFoundException e) {
            monitor.done();
            PluginLogger.logError((String)"Archivo no existente.", (String)"ec.gob.sri.dimm.ats.ui", (Exception)e);
            throw new InterruptedException("El archivo '" + this.archivoXML.getAbsolutePath() + "' no existe.");
        }
        if (resultado != null && (resultado.tieneVariosErrores() || resultado.tieneVariasAdvertencias())) {
            this.resultadoValidacionEsquema = resultado;
            monitor.done();
            return;
        }
        monitor.done();
    }
}

